-- Original translation works of zackdreaver: https://github.com/zackdreaver/ROenglishRE
-- Continuated by llchrisll at https://github.com/llchrisll/ROenglishRE
-- This file can be distributed, used and modified freely
-- This file shouldn't be claimed as part of your project, unless you fork it from https://github.com/llchrisll/ROenglishRE
-- Credits to Neo-Mind for original code.
-- For further information, please visit https://llchrisll.github.io/ROTPDocs/guides/customs/#multi-iteminfo-support.

-- Load the splited function file
require("SystemEN/LuaFiles514/itemInfo_f")

-- Load the translation file
dofile("SystemEN/LuaFiles514/itemInfo.lua")

-- Load the file for custom items and overrides
dofile("SystemEN/itemInfo_Custom.lua")
dofile("SystemEN/itemInfo_Enchant.lua")
dofile("SystemEN/itemInfo_Pets.lua")
dofile("SystemEN/itemInfo_Profession.lua")
dofile("SystemEN/itemInfo_Progression.lua")
dofile("SystemEN/itemInfo_Unlock.lua")

-- Load the additional files
-- Example: (Yes you could add kRO itemInfo itself, but prepare for lua errors)
--dofile("System/itemInfo_true.lub")

---------------- Additional Configs for translation file ----------------
-- Display origin server based on translation file's Server argument
-- 0 = disable/1 = in Item Name/2 = top of description/3 = bottom of description
DisplayServer = 1

-- Defines how the item id will be shown in item name, doesn't take effect in other settings
TagStart = '('
TagEnd = ')'

-- Define the colour in which the Server Name should be shown (affects official)
-- Format: '^<RRGGBB>'
-- '' = same color as "Server: " (^0000CC = blue)
-- '^FFFFFF' = white
ServerColour = '^FF0000'

-- Show ItemID at bottom (affects custom items as well)
-- 0 = disable/1 = top of description/2 = bottom of description
DisplayItemID = 2

-- Display a database link at bottom of description (true/false)
DisplayDatabase = true

---------------- Additional Configs for custom items ----------------
-- Display server name
-- 0 = disable/1 = in Item Name/2 = top of description/3 = bottom of description
DisplayCustomServer = 0

-- Defines how the item id will be shown in item name, doesn't take effect in other settings
CustomTagStart = '['
CustomTagEnd = ']'

-- Server Name for your custom items
CServerName = 'ExampleRO'

-- Define the colour in which the custom Server Name should be shown (custom items)
-- Format: '^<RRGGBB>'
-- '' = same color as "Server: " (^0000CC = blue)
-- '^FFFFFF' = white
CServerColour = '^00FF00'

-- Database link for custom items, like fluxcp (true/false)
DisplayCustomDB = true

----- Table for Database Links -------------------
ItemDatabase = {
	["Divine-Pride"] = {
		Name = "Item Database",
		URL = "https://www.divine-pride.net/database/item/"
	},
	["iRO"] = {
		Name = "Item Database",
		URL = "https://www.divine-pride.net/database/item/"
	},
	["Custom"] = {
		Name = "Item Database",
		URL = "https://www.divine-pride.net/database/item/"
	}
}
---------------- Don't touch the functions below unless you know what you are doing ----------------
function itemInfoMerge(src, state)
	if src == nil then
		return
	end
	for ItemID,DESC in pairs(src) do
		if state == false then
			if not tbl[ItemID] then
				tbl[ItemID] = {}
				tbl[ItemID] = DESC
			end
		else
			tbl[ItemID] = DESC
		end
		if src == tbl_custom then
			tbl[ItemID].Custom = true
		end
		if src == tbl_custom_unlock then
			tbl[ItemID].Custom = true
		end
		if src == tbl_custom_pets then
			tbl[ItemID].Custom = true
		end
	end
	return
end

-- itemInfoMerge(src, state)
-- @src = table for merge into tbl
-- @state = overwrite existing entries (true) or not (false)

itemInfoMerge(tbl_override, true) -- official overrides
itemInfoMerge(tbl_override_pets, true) -- official overrides
itemInfoMerge(tbl_custom, false) -- custom items
itemInfoMerge(tbl_custom_enchant, false) -- custom items
itemInfoMerge(tbl_custom_pets, false) -- custom items
itemInfoMerge(tbl_custom_profession, false) -- custom items
itemInfoMerge(tbl_custom_progression, false) -- custom items
itemInfoMerge(tbl_custom_unlock, false) -- custom items
itemInfoMerge(tbl, false) -- original kRO iteminfo
